--> Pralable : restructuration de la base : mis en place d'une table d'adresses et d'une table des lignes d'adresses
/*
USE DB_INDEX;

--> cration de la table des adresses
SELECT IDENTITY(INT, 1, 1) AS ADR_ID, CAST(EMP_ID AS INT) AS EMP_ID, EMP_CP AS ADR_CP, EMP_VILLE AS ADR_VILLE
INTO   T_ADRESSE_ADR
FROM   T_EMPLOYEE_EMP;
GO

--> mise en place des contraintes dans la table des adresses
ALTER TABLE T_ADRESSE_ADR
   ADD CONSTRAINT PK_ADR PRIMARY KEY (ADR_ID),
       CONSTRAINT FK_ADR_EMP FOREIGN KEY (EMP_ID) REFERENCES T_EMPLOYEE_EMP (EMP_ID);
GO

--> cration de la table des lignes d'adresses
WITH 
T AS 
(
SELECT ADR_ID, CAST(1 AS TINYINT) AS ADL_POSITION, EMP_ADRESSE1 AS ADL_LIBELLE
FROM   T_EMPLOYEE_EMP AS E
       INNER JOIN T_ADRESSE_ADR AS A
	         ON E.EMP_ID = A.EMP_ID
WHERE  EMP_ADRESSE1 IS NOT NULL
UNION ALL
SELECT ADR_ID, CAST(2 AS TINYINT) AS ADL_POSITION, EMP_ADRESSE2 AS ADL_LIBELLE
FROM   T_EMPLOYEE_EMP AS E
       INNER JOIN T_ADRESSE_ADR AS A
	         ON E.EMP_ID = A.EMP_ID
WHERE  EMP_ADRESSE2 IS NOT NULL
UNION ALL
SELECT ADR_ID, CAST(3 AS TINYINT) AS ADL_POSITION, EMP_ADRESSE3 AS ADL_LIBELLE
FROM   T_EMPLOYEE_EMP AS E
       INNER JOIN T_ADRESSE_ADR AS A
	         ON E.EMP_ID = A.EMP_ID
WHERE  EMP_ADRESSE3 IS NOT NULL
)
SELECT IDENTITY(INT, 1, 1) AS ADL_ID, ADR_ID, ADL_POSITION, ADL_LIBELLE
INTO   T_ADRESSE_LIGNE_ADL
FROM   T;
GO

--> mise en place des contraintes dans la table des lignes d'adresses
ALTER TABLE T_ADRESSE_LIGNE_ADL
   ADD CONSTRAINT PK_ADL PRIMARY KEY (ADL_ID),
       CONSTRAINT FK_ADL_ADR FOREIGN KEY (ADR_ID) REFERENCES T_ADRESSE_ADR (ADR_ID);
GO;

--> suppression des colonnes inutiles de la table des employs
ALTER TABLE T_EMPLOYEE_EMP
   DROP COLUMN EMP_ADRESSE1,
        COLUMN EMP_ADRESSE2,
        COLUMN EMP_ADRESSE3,
        COLUMN EMP_CP,
        COLUMN EMP_VILLE;
*/

--> Pralable 
--  USE DB_INDEX;

CREATE INDEX X_EMP_NOM ON T_EMPLOYEE_EMP (EMP_NOM);

SET STATISTICS TIME ON;

SELECT DISTINCT E.EMP_ID, EMP_NOM
FROM   T_EMPLOYEE_EMP AS E
       INNER JOIN T_ADRESSE_ADR AS A
             ON E.EMP_NOM = A.ADR_VILLE;

SELECT DISTINCT E.EMP_ID, EMP_NOM
FROM   T_EMPLOYEE_EMP AS E
       INNER MERGE JOIN T_ADRESSE_ADR AS A
             ON E.EMP_NOM = A.ADR_VILLE;